/*ident	"@(#)G2++:g2++lib/geng2ctab.c	3.4" */
/******************************************************************************
*
* C++ Standard Components, Release 3.0.
*
* Copyright (c) 1991, 1992 AT&T and Unix System Laboratories, Inc.
* Copyright (c) 1988, 1989, 1990 AT&T.  All Rights Reserved.
*
* THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T and Unix System
* Laboratories, Inc.  The copyright notice above does not evidence
* any actual or intended publication of such source code.
*
******************************************************************************/

//  This program generates character mapping tables
//  into the file g2ctab.c

#include <ctype.h>
#include <osfcn.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef LSC
#   define main _main
    int	dochar(int c, FILE *f);
#endif

char* g2filename_ATTLC = "g2ctab.c";
char* g2progname_ATTLC = "geng2ctab";

char* g2legend_ATTLC[] = {
 
    "//000\t001\t002\t003\t004\t005\t006\t007\n//nul\t ^A\t ^B\t ^C\t ^D\t ^E\t ^F\t ^G",
    "//010\t011\t012\t013\t014\t015\t016\t017\n// ^H\t ^I\t ^J\t ^K\t ^L\t ^M\t ^N\t ^O",
    "//020\t021\t022\t023\t024\t025\t026\t027\n// ^P\t ^Q\t ^R\t ^S\t ^T\t ^U\t ^V\t ^W",
    "//030\t031\t032\t033\t034\t035\t036\t037\n// ^X\t ^Y\t ^Z\t ^[\t ^\\\t ^]\t ^^\t ^_",
    "//040\t041\t042\t043\t044\t045\t046\t047\n// sp\t  !\t  \"\t  #\t  $\t  %\t  &\t  '",
    "//050\t051\t052\t053\t054\t055\t056\t057\n//  (\t  )\t  *\t  +\t  ,\t  -\t  .\t  /",
    "//060\t061\t062\t063\t064\t065\t066\t067\n//  0\t  1\t  2\t  3\t  4\t  5\t  6\t  7",
    "//070\t071\t072\t073\t074\t075\t076\t077\n//  8\t  9\t  :\t  ;\t  <\t  =\t  >\t  ?",
    "//100\t101\t102\t103\t104\t105\t106\t107\n//  @\t  A\t  B\t  C\t  D\t  E\t  F\t  G",
    "//110\t111\t112\t113\t114\t115\t116\t117\n//  H\t  I\t  J\t  K\t  L\t  M\t  N\t  O",
    "//120\t121\t122\t123\t124\t125\t126\t127\n//  P\t  Q\t  R\t  S\t  T\t  U\t  V\t  W",
    "//130\t131\t132\t133\t134\t135\t136\t137\n//  X\t  Y\t  Z\t  [\t  \\\t  ]\t  ^\t  _",
    "//140\t141\t142\t143\t144\t145\t146\t147\n//  `\t  a\t  b\t  c\t  d\t  e\t  f\t  g",
    "//150\t151\t152\t153\t154\t155\t156\t157\n//  h\t  i\t  j\t  k\t  l\t  m\t  n\t  o",
    "//160\t161\t162\t163\t164\t165\t166\t167\n//  p\t  q\t  r\t  s\t  t\t  u\t  v\t  w",
    "//170\t171\t172\t173\t174\t175\t176\t177\n//  x\t  y\t  z\t  {\t  |\t  }\t  -\t ^?"

};

main(){
    int	i,row;
    FILE* f;

    if( 
	(f=fopen(g2filename_ATTLC, "w")) == NULL 
    ){
	fprintf(stderr, "geng2ctab: cannot open '%s'\n", g2filename_ATTLC);
	exit(1);
    }
    fprintf(f, "/*ident	\"@(#)G2++:g2++lib/g2ctab.c	3.0\"  */\n");

    fprintf(f, "/******************************************************************************\n");
    fprintf(f, "*\n");
    fprintf(f, "* C++ Standard Components, Release 3.0.\n");
    fprintf(f, "*\n");
    fprintf(f, "* Copyright (c) 1991, 1992 AT&T and Unix System Laboratories, Inc.\n");
    fprintf(f, "* Copyright (c) 1988, 1989, 1990 AT&T.  All Rights Reserved.\n");
    fprintf(f, "*\n");
    fprintf(f, "* THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T and Unix System\n");
    fprintf(f, "* Laboratories, Inc.  The copyright notice above does not evidence\n");
    fprintf(f, "* any actual or intended publication of such source code.\n");
    fprintf(f, "*\n");
    fprintf(f, "******************************************************************************/\n\n");

    fprintf(f, "//\n");
    fprintf(f, "//  This file is generated by the program 'geng2ctab'\n");
    fprintf(f, "//\n");
    fprintf(f, "#include <g2ctype.h>\n");

//  Digit table (g2Dtab_ATTLC)

    row = 0;
    fprintf(f, "\nint	g2Dtab_ATTLC[] = {  // Digits\n");
    fprintf(f, "0,");

    for( i = 0; i < 128; i++ ){
	if( i%8 == 0 ){
	    fprintf(f,"\n\n%s\n",g2legend_ATTLC[row++]);
	}
	fprintf(f, "%d,", isdigit(i)!=0);
	if( i%8 != 7){
	    fprintf(f,"\t");
	}
    }
    fprintf(f, "\n\n/* chars 0200-0377: */");
    for( i = 128; i < 256; i += 8 ){
	fprintf(f, "\n0,\t0,\t0,\t0,\t0,\t0,\t0,\t0,");
    }
    fprintf(f, "\n};\n");

//  Printable character table (g2Ptab_ATTLC)

    row = 0;
    fprintf(f, "\nint	g2Ptab_ATTLC[] = {  // Printable characters\n");
    fprintf(f, "0,");

    for( i = 0; i < 128; i++ ){
	if( i%8 == 0 ){
	    fprintf(f,"\n\n%s\n",g2legend_ATTLC[row++]);
	}
	fprintf(f, "%d,", isprint(i)!=0);
	if( i%8 != 7){
	    fprintf(f,"\t");
	}
    }
    fprintf(f, "\n\n/* chars 0200-0377: */");
    for( i = 128; i < 256; i += 8 ){
	fprintf(f, "\n0,\t0,\t0,\t0,\t0,\t0,\t0,\t0,");
    }
    fprintf(f, "\n};\n");

//  Alphabetic character table (g2N1tab_ATTLC)

    row = 0;
    fprintf(f, "\nint	g2N1tab_ATTLC[] = {  // Alphabetic characters\n");
    fprintf(f, "0,");

    for( i = 0; i < 128; i++ ){
	if( i%8 == 0 ){
	    fprintf(f,"\n\n%s\n",g2legend_ATTLC[row++]);
	}
	fprintf(f, "%d,", isalpha(i) || i == '_');
	if( i%8 != 7){
	    fprintf(f,"\t");
	}
    }
    fprintf(f, "\n\n/* chars 0200-0377: */");
    for( i = 128; i < 256; i += 8 ){
	fprintf(f, "\n0,\t0,\t0,\t0,\t0,\t0,\t0,\t0,");
    }
    fprintf(f, "\n};\n");

//  Figure-this-one-out table (g2N2tab_ATTLC)

    row = 0;
    fprintf(f, "\nint	g2N2tab_ATTLC[] = {  // Cludge\n");
    fprintf(f, "0,");

    for( i = 0; i < 128; i++ ){
	if( i%8 == 0 ){
	    fprintf(f,"\n\n%s\n",g2legend_ATTLC[row++]);
	}
	fprintf(
	    f, 
	    "%d,", 
	    (
		isalpha(i) || 
		i == '_'   || 
		i == '*'   ||         // jfi
		i == '('   ||         // jfi
		i == ')'   ||         // jfi
		isdigit(i)
	    )
	);
	if( i%8 != 7){
	    fprintf(f,"\t");
	}
    }
    fprintf(f, "\n\n/* chars 0200-0377: */");
    for( i = 128; i < 256; i += 8 ){
	fprintf(f, "\n0,\t0,\t0,\t0,\t0,\t0,\t0,\t0,");
    }
    fprintf(f, "\n};\n");
    fclose(f);
    exit(0);
}
